
import argparse, subprocess, sys

def main(cfg):
    cmds = [
        ["python","scripts/step0_preflight.py","--config",cfg],
        ["python","scripts/step1_tstar.py","--config",cfg],
        ["python","scripts/step2_ugm.py","--config",cfg],
        ["python","scripts/step3_sr.py","--config",cfg],
    ]
    for cmd in cmds:
        print("\n=== Running:", " ".join(cmd))
        try:
            subprocess.run(cmd, check=False)
        except Exception as e:
            print("Step failed to launch:", e)
    print("\nAll steps attempted. See out/ for artifacts.")

if __name__ == "__main__":
    ap = argparse.ArgumentParser()
    ap.add_argument("--config", default="configs/low_compute.yaml")
    args = ap.parse_args()
    main(args.config)
